/**
 * Look at this repo for more info how this will work
 * Piece of this code is copied from below
 * https://github.com/erkserkserks/h264ify
 */

function inject () {
  override();

  function override() {
    // Override video element canPlayType() function
    var videoElem = document.createElement('video');
    var origCanPlayType = videoElem.canPlayType.bind(videoElem);
    videoElem.__proto__.canPlayType = makeModifiedTypeChecker(origCanPlayType);

    // Override media source extension isTypeSupported() function
    var mse = window.MediaSource;
    // Check for MSE support before use
    if (mse === undefined) return;
    var origIsTypeSupported = mse.isTypeSupported.bind(mse);
    mse.isTypeSupported = makeModifiedTypeChecker(origIsTypeSupported);
  }

  // return a custom MIME type checker that can defer to the original function
  function makeModifiedTypeChecker(origChecker) {
    // Check if a video type is allowed
    return function (type) {
      if (type === undefined) return '';
      var disallowed_types = ['webm', 'vp8', 'vp9', 'av01'];
      // If video type is in disallowed_types, say we don't support them
      for (var i = 0; i < disallowed_types.length; i++) {
        if (type.indexOf(disallowed_types[i]) !== -1) return '';
      }

      // Otherwise, ask the browser
      return origChecker(type);
    };
  }
}

var isChromeApp = typeof(chrome) !== 'undefined';

if(isChromeApp){ // for chrome app
  var injectScript = document.createElement('script');
  // Use textContent instead of src to run inject() synchronously
  injectScript.textContent = inject.toString() + "inject();";
  injectScript.onload = function() {
    // Remove <script> node after injectScript runs.
    this.parentNode.removeChild(this);
  };
  (document.head || document.documentElement).appendChild(injectScript);
}else{ // for electron app
  window.onload = function() {
    inject();
  }
}